<?php
defined('_VALID') or die('Restricted Access!');

Auth::checkAdmin();

require $config['BASE_DIR']. '/include/function_video.php';
require $config['BASE_DIR']. '/classes/pagination.class.php';

$thumb_dir      = $config['TMB_DIR'];
$video_dir      = $config['VDO_DIR'];
$flvideo_dir    = $config['FLVDO_DIR'];
$tmp_dir        = $config['TMP_DIR']. '/thumbs';
if ( !file_exists($thumb_dir) or !is_dir($thumb_dir) or !is_writable($thumb_dir) ) {
    $errors[] = 'Thumb directory ' .$thumb_dir. ' does not exist or not writable!';
}
if ( !file_exists($video_dir) or !is_dir($video_dir) or !is_writable($video_dir) ) {
    $errrors[] = 'Video directory ' .$video_dir. ' does not exist or not writable!';
}
if ( !file_exists($flvideo_dir) or !is_dir($flvideo_dir) or !is_writable($flvideo_dir) ) {
    $errors[] = 'FLVideo directory ' .$flvideo_dir. ' does not exist or not writable!';
}
if ( !file_exists($tmp_dir) or !is_dir($tmp_dir) or !is_writable($tmp_dir) ) {
    $errors[] = 'Temporary directory ' .$tmp_dir. ' does not exist or not writable!';
}

if (isset($_POST['delete_selected_videos'])) {
    $index = 0;
    foreach ( $_POST as $key => $value ) {
        if ( $key != 'check_all_videos' && substr($key, 0, 18) == 'video_id_checkbox_') {        
            if ( $value == 'on' ) {
                deleteVideo(str_replace('video_id_checkbox_', '', $key));
                ++$index;
            }
        }
    }
    
    if ( $index === 0 ) {
        $errors[]   = 'Please select videos to be deleted!';
    } else {
        $messages[] = 'Successfully deleted ' .$index. ' (selected) videos!';
    }
}

if (isset($_POST['suspend_selected_videos']) || isset($_POST['approve_selected_videos']) ) {
    $act        = 1;
    $act_name   = 'activated';
    $index      = 0;
    if ( isset($_POST['suspend_selected_videos']) ) {
        $act        = 0;
        $act_name   = 'suspended';
    }

    foreach ( $_POST as $key => $value ) {
        if ( $key != 'check_all_videos' && substr($key, 0, 18) == 'video_id_checkbox_') {        
            if ( $value == 'on' ) {
                $vid = intval(str_replace('video_id_checkbox_', '', $key));
                $sql = "UPDATE video SET active = '" .$act. "' WHERE VID = " .$vid. " LIMIT 1";
                $conn->execute($sql);
                if ( $act_name == 'activated' ) {
                    send_video_approve_email($vid);
                }
                ++$index;
            }
        }
    }
    
    if ( $index === 0 ) {
        $errors[]   = 'Please select videos to be ' .$act_name. '!';
    } else {    
        $messages[] = 'Successfully ' .$act_name. ' ' .$index. ' (selected) videos!';
    }
}

$remove = NULL;
if ( isset($_GET['a']) && $_GET['a'] != '' ) {
    $action = trim($_GET['a']);
    $VID    = ( isset($_GET['VID']) && is_numeric($_GET['VID']) && videoExists($_GET['VID']) ) ? trim($_GET['VID']) : NULL;
    if ( $VID ) {
        switch ( $action ) {
            case 'delete':
                deleteVideo($VID);
                $messages[] = 'Video deleted successfuly!';
                $remove = '&a=delete&VID=' .$VID;
                break;
            case 'suspend':
                $sql = "UPDATE video SET active = '0' WHERE VID = '" .mysql_real_escape_string($VID). "' LIMIT 1";
                $conn->execute($sql);
                $messages[] = 'Video suspended successfuly!';
                $remove = '&a=suspend&VID=' .$VID;
                break;
            case 'activate':
                $sql = "UPDATE video SET active = '1' WHERE VID = '" .mysql_real_escape_string($VID). "' LIMIT 1";
                $conn->execute($sql);
                send_video_approve_email($VID);
                $messages[] = 'Video activated successfuly!';
                $remove = '&a=activate&VID=' .$VID;
                break;
            case 'regenthumbs':
				extract_video_thumbs($config['BASE_DIR'].'/media/videos/flv/'.$VID. '.flv', $VID);
                VRedirect::go('videos.php?m=' .$module_keep. '&msg=Thumbs regenerated successfuly!');
                break;
        }
    } else {
        $err = 'Invalid video id. Video does not exist!?';
    }
}

$query          = constructQuery($module_keep);
$sql            = $query['count'];
$rs             = $conn->execute($sql);
$total_videos   = $rs->fields['total_videos'];
$pagination     = new Pagination($query['page_items']);
$limit          = $pagination->getLimit($total_videos);
$paging         = $pagination->getAdminPagination($remove);
$sql            = $query['select']. " LIMIT " .$limit;
$rs             = $conn->execute($sql);
$videos         = $rs->getrows();

function constructQuery($module)
{
    global $smarty;

    $query_module = '';
    if ( $module == 'private' or $module == 'public' )
            $query_module = " AND v.type = '" .$module. "'";

    $query              = array();
    $query_select       = "SELECT v.*,s.username FROM video AS v, signup AS s WHERE v.UID = s.UID" .$query_module;
    $query_count        = "SELECT count(v.VID) AS total_videos FROM video AS v WHERE v.VID != ''" .$query_module;
    $query_add          = ( $query_module != '' ) ? " AND" : " WHERE";
    $query_option       = array();
    $channel            = ( isset($_GET['CID']) && is_numeric($_GET['CID']) && channelExists($_GET['CID']) ) ? trim($_GET['CID']) : NULL;
    $option             = array('username' => '', 'title' => '', 'description' => '', 'keyword' => '', 'channel' => $channel, 'active' => '',
                                'sort' => 'VID', 'order' => 'DESC', 'display' => 100);
            
    if ( isset($_POST['search_videos']) ) {
        $option['username']     = trim($_POST['username']);
        $option['title']        = trim($_POST['title']);
        $option['description']  = trim($_POST['description']);
        $option['keyword']      = trim($_POST['keyword']);
        $option['channel']      = intval(trim($_POST['channel']));
        $option['active']       = trim($_POST['active']);
        $option['sort']         = trim($_POST['sort']);
        $option['order']        = trim($_POST['order']);
        $option['display']      = trim($_POST['display']);
    }    
    
    if ( $option['username'] != '' || isset($_GET['UID']) ) {
        if ( $option['username'] != '' ) {
            $UID            = getUserID($option['username']);
        } else {
            $UID            = ( isset($_GET['UID']) && is_numeric($_GET['UID']) ) ? $_GET['UID'] : 0;
        }
        $UID            = ( $UID ) ? $UID : 0;
        $query_option[] = " AND v.UID = '" .mysql_real_escape_string($UID). "'";
    }

    if ( $option['title'] != '' ) {
        $query_option[] = " AND v.title LIKE '%" .mysql_real_escape_string($option['title']). "%'";
    }

    if ( $option['description'] != '' ) {
        $query_option[] = " AND v.description LIKE '%" .mysql_real_escape_string($option['description']). "%'";
    }
        
    if ( $option['keyword'] != '' ) {
        $query_option[] = " AND v.keyword LIKE '%" .mysql_real_escape_string($option['keyword']). "%'";
    }

    if ( $option['channel'] != '' ) {
        $query_option[] = " AND v.channel = " .intval($option['channel']);
    }

    if ( $option['active'] == '0' || $option['active'] == '1' ) {
        $query_option[] = " AND v.active = '" .$option['active']. "'";
    }

    $query_option[]         = " ORDER BY " .$option['sort']. " " .$option['order'];    
    $query['select']        = $query_select .implode(' ', $query_option);
    $query['count']         = $query_count .implode(' ', $query_option);
    $query['page_items']    = $option['display'];
    
    $smarty->assign('option', $option);
    
    return $query;
}

function getUserID( $username )
{
    global $conn;
    
    $sql = "SELECT UID FROM signup WHERE username = '" .mysql_real_escape_string($username). "' LIMIT 1";
    $rs  = $conn->execute($sql);
    if ( $conn->Affected_Rows() == 1 )
        return $rs->fields['UID'];
    
    return false;
}

$smarty->assign('videos', $videos);
$smarty->assign('total_videos', $total_videos);
$smarty->assign('paging', $paging);
$smarty->assign('channels', get_categories());
?>
